package gov.va.vamf.scheduling.direct.domain;


import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.VarUtility)
public class SchedulingDay {

    @XmlElement
    private Day day;

    @XmlElement
    private Boolean canSchedule = true;

    @XmlElement
    private String startTime = "08:00";

    @XmlElement
    private String endTime = "17:00";

    public SchedulingDay(Day day) {
        this.day = day;
    }

    public Day getDay() {
        return day;
    }

    public void setDay(Day day) {
        this.day = day;
    }

    public Boolean getCanSchedule() {
        return canSchedule;
    }

    public void setCanSchedule(Boolean canSchedule) {
        this.canSchedule = canSchedule;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }
}
